/************************************************************************/
/*                                                                      */
/* Borland Enterprise Core Objects                                      */
/*                                                                      */
/* Copyright (c) 2003-2005 Borland Software Corporation                 */
/*                                                                      */
/************************************************************************/

using System;
using System.ComponentModel;
using System.ComponentModel.Design;
using System.Drawing;
using System.Drawing.Design;

using Borland.Eco.Subscription;
using Borland.Eco.Handles;
using Borland.Eco.UmlRt;
using Borland.Eco.ObjectRepresentation;
using Borland.Eco.Services;
using Borland.Eco.Ocl.Support;
using Borland.Eco.Exceptions;
using Borland.Eco.Globalization;

namespace Borland.Eco.Handles
{
	///<summary>
	/// This handle derives its element by applying the ocl-expression Expression to its root.
	///</summary>
	[ToolboxBitmap(typeof(ExpressionHandle), "Borland.Eco.Handles.ExpressionHandle.bmp")]
	[ToolboxItem(true)]
	[Designer("Borland.Eco.Handles.Design.ExpressionHandleDesigner, Borland.Eco.Handles.Design", typeof(IDesigner))]
	public sealed class ExpressionHandle: RootedHandle, IHasEditableExpression
	{

		IStaticContext IHasEditableExpression.StaticContext
		{
			get { return EffectiveRootStaticContext; }
		}

		ExpressionKind IHasEditableExpression.ExpressionKind
		{
			get { return ExpressionKind.Ocl; }
		}

		protected override void DeriveAndSubscribe(ISubscriber valueChangeSubscriber, ISubscriber resubscribeSubscriber)
		{
			if (Active)
			{
				InternalElement = ((IOclService)GetEcoService(typeof(IOclService))).EvaluateAndSubscribe(EffectiveRootValue(), EffectiveRootStaticContext.StaticUmlType, EffectiveVariables(), Expression, valueChangeSubscriber, resubscribeSubscriber);
			}
			else
				InternalElement = null;
		}

		protected override bool RefersToComponent(object component)
		{
			bool result = base.RefersToComponent(component);
			if (!result && (component != null))
			{
				result = (component == Variables);
			}
			return result;
		}

		protected override sealed IClassifier GetStaticUmlType()
		{
			if (EffectiveRootStaticContext.OclTypeService != null)
				try
				{
					return EffectiveRootStaticContext.OclTypeService.ExpressionType(Expression, EffectiveRootStaticContext.StaticUmlType, false, EffectiveVariables());
				}
				catch
				{
					// Ignore errors, just return null type.
				}
			return null;
		}

		private string m_Expression = string.Empty;
		/// <summary>
		/// The OCL expression to be used when deriving the value of the handle.
		/// The Element property is set to the value obtained by applying this
		/// property to the RootHandle.Element.
		/// </summary>
		[LocalizableCategory(typeof(HandlesStringRes), "sCategoryOCL")]
		[LocalizableDescription(typeof(HandlesStringRes), "sPropertyExpression")]
		[Editor("Borland.Eco.Handles.Design.OclEditorWakeup, Borland.Eco.Handles.Design", typeof(UITypeEditor))]
		[DefaultValue("")]
		public string Expression
		{
			get { return m_Expression; }
			set
			{
				if (value != m_Expression)
				{
					m_Expression = value;
					MarkSubscriptionOutOfDate();
					StaticContextChanged();
				}
			}
		}
	}

}
